% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_remove}
\alias{omnipath_cache_remove}
\title{Removes contents from the cache directory}
\usage{
omnipath_cache_remove(key = NULL, url = NULL, post = NULL,
    payload = NULL, max_age = NULL, min_age = NULL, status = NULL,
    only_latest = FALSE, wipe = FALSE, autoclean = TRUE)
}
\arguments{
\item{key}{The key of the cache record}

\item{url}{URL pointing to the resource}

\item{post}{HTTP POST parameters as a list}

\item{payload}{HTTP data payload}

\item{max_age}{Age of cache items in days. Remove everything that is older
than this age}

\item{min_age}{Age of cache items in days. Remove everything more recent
than this age}

\item{status}{Remove items having any of the states listed here}

\item{only_latest}{Keep only the latest version}

\item{wipe}{Logical: if TRUE, removes all files from the cache and the
cache database. Same as calling \code{\link{omnipath_cache_wipe}}.}

\item{autoclean}{Remove the entries about failed downloads, the files in
the cache directory which are missing from the cache database, and the
entries without existing files in the cache directory}
}
\value{
Invisibly returns the cache database (list of cache records).
}
\description{
According to the parameters, it can remove contents older than a certain
age, or contents having a more recent version, one specific item, or
wipe the entire cache.
}
\examples{
\dontrun{
# remove all cache data from the BioPlex database
cache_records <- omnipath_cache_search(
    'bioplex',
    ignore.case = TRUE
)
omnipath_cache_remove(names(cache_records))

# remove a record by its URL
regnetwork_url <- 'http://www.regnetworkweb.org/download/human.zip'
omnipath_cache_remove(url = regnetwork_url)

# remove all records older than 30 days
omnipath_cache_remove(max_age = 30)

# for each record, remove all versions except the latest
omnipath_cache_remove(only_latest = TRUE)
}

bioc_url <- 'https://bioconductor.org/'
version <- omnipath_cache_latest_or_new(url = bioc_url)
curl::curl_fetch_disk(bioc_url, version$path)
omnipath_cache_download_ready(version)
key <- omnipath_cache_key(bioc_url)
omnipath_cache_remove(key = key)


}
\seealso{
\itemize{
    \item{\code{\link{omnipath_cache_wipe}}}
    \item{\code{\link{omnipath_cache_clean}}}
    \item{\code{\link{omnipath_cache_autoclean}}}
}
}
