% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oma.R
\name{oma_pairwise}
\alias{oma_pairwise}
\title{Orthologous gene pairs between two organisms}
\usage{
oma_pairwise(
  organism_a = "human",
  organism_b = "mouse",
  id_type = "uniprot",
  mappings = c("1:1", "1:m", "n:1", "n:m"),
  only_ids = TRUE
)
}
\arguments{
\item{organism_a}{Name or identifier of an organism.}

\item{organism_b}{Name or identifier of another organism.}

\item{id_type}{The gene or protein identifier to use in the table. For a
list of supported ID types see `omnipathr.env$id_types$oma`. In addition,
"genesymbol" is supported, in this case
\code{\link{oma_pairwise_genesymbols}} will be called automatically.}

\item{mappings}{Character vector: control ambiguous mappings: \itemize{
    \item{1:1 - unambiguous}
    \item{1:m - one-to-many}
    \item{n:1 - many-to-one}
    \item{n:m - many-to-many}
}}

\item{only_ids}{Logical: include only the two identifier columns, not the
mapping type and the orthology group columns.}
}
\value{
A data frame with orthologous gene pairs.
}
\description{
From the web API of Orthologous Matrix (OMA). Items which could not be
translated to `id_type` (but present in the data with their internal OMA
IDs) are removed.
}
\examples{
oma_pairwise("human", "mouse", "uniprot")
# # A tibble: 21,753 × 4
#    id_organism_a id_organism_b mapping oma_group
#    <chr>         <chr>         <chr>       <dbl>
#  1 Q15326        Q8R5C8        1:1       1129380
#  2 Q9Y2E4        B2RQ71        1:1        681224
#  3 Q92615        Q6A0A2        1:1       1135087
#  4 Q9BZE4        Q99ME9        1:1       1176239
#  5 Q9BXS1        Q8BFZ6        1:m            NA
# # … with 21,743 more rows

}
