% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_ligand_target_links}
\alias{nichenet_ligand_target_links}
\title{Compiles a table with weighted ligand-target links}
\usage{
nichenet_ligand_target_links(
  ligand_activities,
  ligand_target_matrix,
  genes_of_interest,
  n_top_ligands = 42,
  n_top_targets = 250
)
}
\arguments{
\item{ligand_activities}{Ligand activity table as produced by
\code{nichenetr::predict_ligand_activities}.}

\item{ligand_target_matrix}{Ligand-target matrix as produced by
\code{nichenetr::construct_ligand_target_matrix} or the wrapper
around it in the current package:
\code{\link{nichenet_ligand_target_matrix}}.}

\item{genes_of_interest}{Character vector with the gene symbols of the
genes of interest. These are the genes in the receiver cell population
that are potentially affected by ligands expressed by interacting
cells (e.g. genes differentially expressed upon cell-cell interaction).}

\item{n_top_ligands}{How many of the top ligands to include in the
ligand-target table.}

\item{n_top_targets}{For each ligand, how many of the top targets to
include in the ligand-target table.}
}
\value{
A tibble with columns ligand, target and weight (i.e. regulatory
    potential score).
}
\description{
A wrapper around \code{nichenetr::get_weighted_ligand_target_links} to
compile a data frame with weighted links from the top ligands to their
top targets.
}
\examples{
\dontrun{
networks <- nichenet_networks()
expression <- nichenet_expression_data()
optimization_results <- nichenet_optimization(networks, expression)
nichenet_model <- nichenet_build_model(optimization_results, networks)
lt_matrix <- nichenet_ligand_target_matrix(
    nichenet_model$weighted_networks,
    networks$lr_network,
    nichenet_model$optimized_parameters
)
ligand_activities <- nichenet_ligand_activities(
    ligand_target_matrix = lt_matrix,
    lr_network = networks$lr_network,
    # the rest of the parameters should come
    # from your transcriptomics data:
    expressed_genes_transmitter = expressed_genes_transmitter,
    expressed_genes_receiver = expressed_genes_receiver,
    genes_of_interest = genes_of_interest
)
lt_links <- nichenet_ligand_target_links(
    ligand_activities = ligand_activities,
    ligand_target_matrix = lt_matrix,
    genes_of_interest = genes_of_interest,
    n_top_ligands = 20,
    n_top_targets = 100
)
}

}
