% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{go_annot_slim}
\alias{go_annot_slim}
\title{GO slim gene annotations}
\usage{
go_annot_slim(
  organism = "human",
  slim = "generic",
  aspects = c("C", "F", "P"),
  cache = TRUE
)
}
\arguments{
\item{organism}{Character: either "chicken", "cow", "dog", "human", "pig"
or "uniprot_all".}

\item{slim}{Character: the GO subset (GO slim) name. Available GO
slims are: "agr" (Alliance for Genomics Resources), "generic",
"aspergillus", "candida", "drosophila", "chembl", "metagenomic",
"mouse", "plant", "pir" (Protein Information Resource), "pombe"
and "yeast".}

\item{aspects}{Character vector with some of the following elements:
"C" (cellular component), "F" (molecular function) and "P" (biological
process). Gene Ontology is three separate ontologies called as three
aspects. By this parameter you can control which aspects to include
in the output.}

\item{cache}{Logical: Load the result from cache if available.}
}
\value{
A tibble (data frame) of genes annotated with ontology terms in
    in the GO slim (subset).
}
\description{
GO slims are subsets of the full GO which "give a broad overview of the
ontology content without the detail of the specific fine grained terms".
In order to annotate genes with GO slim terms, we take the annotations
and search all ancestors of the terms up to the root of the ontology
tree. From the ancestors we select the terms which are part of the slim
subset.
}
\details{
Building the GO slim is resource intensive in its current implementation.
For human annotation and generic GO slim it might take around 20 minutes.
The result is saved into the cache so next time loading the data from
there is really quick. If the \code{cache} option is \code{FALSE} the
data will be built fresh (the annotation and ontology files still might
come from cache), and the newly build GO slim will overwrite the cache
instance.
}
\examples{
\dontrun{
goslim <- go_annot_slim(organism = 'human', slim = 'generic')
goslim
# # A tibble: 276,371 x 8
#    db     db_object_id db_object_symbol go_id aspect db_object_name
#    <fct>  <chr>        <chr>            <chr> <fct>  <chr>
#  1 UniPr. A0A024RBG1   NUDT4B           GO:0. F      Diphosphoinosito.
#  2 UniPr. A0A024RBG1   NUDT4B           GO:0. F      Diphosphoinosito.
#  3 UniPr. A0A024RBG1   NUDT4B           GO:0. C      Diphosphoinosito.
#  4 UniPr. A0A024RBG1   NUDT4B           GO:0. C      Diphosphoinosito.
#  5 UniPr. A0A024RBG1   NUDT4B           GO:0. C      Diphosphoinosito.
# # . with 276,366 more rows, and 2 more variables:
# #   db_object_synonym <chr>, db_object_type <fct>
}

}
\seealso{
\itemize{
    \item{\code{\link{go_annot_download}}}
    \item{\code{\link{go_ontology_download}}}
    \item{\code{\link{get_db}}}
}
}
