% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{get_ontology_db}
\alias{get_ontology_db}
\title{Access an ontology database}
\usage{
get_ontology_db(key, rel_fmt = "tbl", child_parents = TRUE)
}
\arguments{
\item{key}{Character: key of the ontology database. For the available keys
see \code{\link{omnipath_show_db}}.}

\item{rel_fmt}{Character: the data structure of the ontology relations.
Posible values are 1) "tbl" a data frame, 2) "lst" a list or 3) "gra"
a graph.}

\item{child_parents}{Logical: whether the ontology relations should point
from child to parents (\code{TRUE}) or from parent to children
(\code{FALSE}).}
}
\value{
A list with the following elements: 1) "names" a table with
    term IDs and names; 2) "namespaces" a table to connect term IDs
    and namespaces they belong to; 3) "relations" a table with
    relations between terms and their parent terms; 4) "subsets" a
    table with terms and the subsets they are part of; 5) "obsolete"
    character vector with all the terms labeled as obsolete.
}
\description{
Retrieves an ontology database with relations in the desired data
structure. The database is automatically loaded and the requested data
structure is constructed if necessary. The databases stay loaded up to a
certain time period (see the option \code{omnipathr.db_lifetime}). Hence
the first one of repeated calls to this function might take long and the
subsequent ones should be really quick.
}
\examples{
go <- get_ontology_db('go_basic', child_parents = FALSE)

}
\seealso{
\itemize{
    \item{\code{\link{omnipath_show_db}}}
    \item{\code{\link{get_db}}}
}
}
