% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap.R
\name{remap_tf_target_download}
\alias{remap_tf_target_download}
\title{Downloads TF-target interactions from ReMap}
\usage{
remap_tf_target_download()
}
\value{
Data frame with TF-target relationships.
}
\description{
ReMap (\url{http://remap.univ-amu.fr/}) is a database of ChIP-Seq
experiments. It provides raw and merged peaks and CRMs (cis regulatory
motifs) with their associations to regulators (TFs). TF-target
relationships can be derived as it is written in Garcia-Alonso et al.
2019: "For ChIP-seq, we downloaded the binding peaks from ReMap and scored
the interactions between each TF and each gene according to the distance
between the TFBSs and the genes’ transcription start sites. We evaluated
different filtering strategies that consisted of selecting only the
top-scoring 100, 200, 500, and 1000 target genes for each TF."
(\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6673718/#s1title}).
This function retrieves the full processed TF-target list from the data
deposited in \url{https://zenodo.org/record/3713238}.
}
\examples{
\dontrun{
remap_interactions <- remap_tf_target_download()
remap_interactions
# # A tibble: 9,546,470 x 4
#    source_genesymbol target_genesymbol target_ensembl     score
#    <chr>             <chr>             <chr>              <dbl>
#  1 ADNP              PTPRS             ENSG00000105426.16  1000
#  2 AFF4              PRKCH             ENSG00000027075.14  1000
#  3 AHR               CTNND2            ENSG00000169862.18  1000
#  4 AR                PDE4D             ENSG00000113448.18  1000
#  5 ARID1A            PLEC              ENSG00000178209.14  1000
# # . with 9,546,460 more rows
}


}
\seealso{
\itemize{
    \item{\code{\link{remap_dorothea_download}}}
    \item{\code{\link{remap_filtered}}}
}
}
