% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{oma_code}
\alias{oma_code}
\title{Orthologous Matrix (OMA) codes of organisms}
\usage{
oma_code(name)
}
\arguments{
\item{name}{Vector with any kind of organism name or identifier, can be
also mixed type.}
}
\value{
A character vector with the Orthologous Matrix (OMA) codes of the
    organisms.
}
\description{
Note: OMA species codes are whenever possible identical to UniProt codes.
}
\examples{
oma_code(c(10090, "cjacchus", "Vicugna pacos"))
# [1] "MOUSE" "CALJA" "VICPA"

}
\seealso{
\itemize{
    \item{\code{\link{ncbi_taxid}}}
    \item{\code{\link{latin_name}}}
    \item{\code{\link{ensembl_name}}}
    \item{\code{\link{common_name}}}
}
}
