% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg.R
\name{kegg_picture}
\alias{kegg_picture}
\title{Download a pathway diagram as a picture}
\usage{
kegg_picture(pathway_id, path = NULL)
}
\arguments{
\item{pathway_id}{Character: a KEGG Pathway identifier, e.g. "hsa04710".
For a complete list of IDs see \code{\link{kegg_pathway_list}}.}

\item{path}{Character: save the image to this path. If \code{NULL}, the
image will be saved in the current directory under the name
\code{<pathway_id>.png}.}
}
\value{
Invisibly returns the path to the downloaded file.
}
\description{
Downloads a KEGG Pathway diagram as a PNG image.
}
\examples{
kegg_picture('hsa04710')
kegg_picture('hsa04710', path = 'foo/bar')
kegg_picture('hsa04710', path = 'foo/bar/circadian.png')

}
\seealso{
\code{\link{kegg_pathway_list}}

\itemize{
    \item{\code{\link{kegg_pathway_list}}}
    \item{\code{\link{kegg_open}}}
    \item{\code{\link{kegg_info}}}
}
}
