% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_attrs.R
\name{extra_attrs_to_cols}
\alias{extra_attrs_to_cols}
\title{New columns from extra attributes}
\usage{
extra_attrs_to_cols(data, ..., flatten = FALSE, keep_empty = TRUE)
}
\arguments{
\item{data}{An interaction data frame.}

\item{...}{The names of the extra attributes; NSE is supported. Custom
column names can be provided as argument names.}

\item{flatten}{Logical: unnest the list column even if some records have
multiple values for the attributes; these will yield multiple records
in the resulted data frame.}

\item{keep_empty}{Logical: if `flatten` is `TRUE`, shall we keep the
records which do not have the attribute?}
}
\value{
Data frame with the new column created; the new column is list
    type if one interaction might have multiple values of the attribute,
    or character type if
}
\description{
New columns from extra attributes
}
\examples{
i <- omnipath(fields = "extra_attrs")
extra_attrs_to_cols(i, Cellinker_type, Macrophage_type)
extra_attrs_to_cols(
    i,
    Cellinker_type,
    Macrophage_type,
    flatten = TRUE,
    keep_empty = FALSE
)

}
\seealso{
\itemize{
    \item{\code{\link{extra_attrs}}}
    \item{\code{\link{has_extra_attrs}}}
    \item{\code{\link{with_extra_attrs}}}
    \item{\code{\link{filter_extra_attrs}}}
    \item{\code{\link{extra_attr_values}}}
}
}
