% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{ancestors}
\alias{ancestors}
\title{All ancestors in the ontology tree}
\usage{
ancestors(
  terms,
  db_key = "go_basic",
  ids = TRUE,
  relations = c("is_a", "part_of", "occurs_in", "regulates", "positively_regulates",
    "negatively_regulates")
)
}
\arguments{
\item{terms}{Character vector of ontology term IDs or names. A mixture of
IDs and names can be provided.}

\item{db_key}{Character: key to identify the ontology database. For the
available keys see \code{\link{omnipath_show_db}}.}

\item{ids}{Logical: whether to return IDs or term names.}

\item{relations}{Character vector of ontology relation types. Only these
relations will be used.}
}
\value{
Character vector of ontology IDs. If the input terms are all
    root nodes, \code{NULL} is returned. The starting nodes won't be
    included in the result unless some of them are ancestors of other
    starting nodes.
}
\description{
Starting from the selected nodes, recursively walks the ontology tree
until it reaches the root. Collects all visited nodes, which are the
ancestors (parents) of the starting nodes.
}
\details{
Note: this function relies on the database manager, the first call might
take long because of the database load process. Subsequent calls within
a short period should be faster. See \code{\link{get_ontology_db}}.
}
\examples{
ancestors('GO:0005035', ids = FALSE)
# [1] "molecular_function"
# [2] "transmembrane signaling receptor activity"
# [3] "signaling receptor activity"
# [4] "molecular transducer activity"

}
