% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlForConfounders.R
\name{controlForConfounders}
\alias{controlForConfounders}
\title{Autoencoder function to correct for confounders.}
\usage{
controlForConfounders(
  ods,
  q,
  implementation = c("autoencoder", "pca"),
  BPPARAM = bpparam(),
  ...
)
}
\arguments{
\item{ods}{An OutriderDataSet object}

\item{q}{The encoding dimensions}

\item{implementation}{"autoencoder", the default, will use the autoencoder
implementation. Also 'pca' and 'peer' can be used to control
for confounding effects}

\item{BPPARAM}{A 
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}}
        instance to be used for parallel computing.}

\item{...}{Further arguments passed on to the specific implementation method.}
}
\value{
An ods object including the control factors
}
\description{
This is the wrapper function for the autoencoder implementation. 
It can be used to call the standard R implementation or the experimental
Python implementation.
}
\examples{
ods <- makeExampleOutriderDataSet()
implementation <- 'autoencoder'
\dontshow{
    ods <- ods[1:10,1:10]
    implementation <- 'pca'
}
ods <- estimateSizeFactors(ods)
ods <- controlForConfounders(ods, implementation=implementation)

plotCountCorHeatmap(ods, normalized=FALSE)
plotCountCorHeatmap(ods, normalized=TRUE)

}
