% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterExpression.R
\name{computeGeneLength}
\alias{computeGeneLength}
\title{Extracting the gene length from annotations}
\usage{
computeGeneLength(ods, gtfFile, format = "gtf", mapping = NULL, ...)
}
\arguments{
\item{ods}{An OutriderDataSet for which the gene length should be computed.}

\item{gtfFile}{Can be a GTF file or an txDb object with annotation.}

\item{format}{The format parameter from \code{makeTxDbFromGFF}}

\item{mapping}{If set, it is used to map gene names between the GFT and the
ods object. This should be a 2 column data.frame: 
1. column GTF names and 2. column ods names.}

\item{...}{further arguments to \code{makeTxDbFromGFF}}
}
\value{
An OutriderDataSet containing a \code{basepairs} column with the 
            calculated gene length. Accessable through 
            \code{mcols(ods)['baisepairs']}
}
\description{
Computes the length for each gene based on the given GTF file or annotation.
Here the length of a gene is defind by the total number of bases covered
by exons.
}
\examples{

ods <- makeExampleOutriderDataSet(dataset="GTExSkinSmall")
annotationFile <- system.file("extdata", "gencode.v19.genes.small.gtf.gz",
        package="OUTRIDER")
ods <- computeGeneLength(ods, annotationFile)

mcols(ods)['basepairs']
fpkm(ods)[1:10,1:10]

}
