% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_region.R
\name{stopRegion}
\alias{stopRegion}
\title{Stop region as GRangesList}
\usage{
stopRegion(grl, tx = NULL, is.sorted = TRUE, upstream = 2L, downstream = 2L)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object
with usually either leaders, cds', 3' utrs or ORFs}

\item{tx}{default NULL, a GRangesList of transcripts or (container region),
names of tx must contain all grl names. The names of grl can also be the
ORFik orf names. that is "txName_id"}

\item{is.sorted}{logical (TRUE), is grl sorted.}

\item{upstream}{an integer (2), relative region to get upstream from.}

\item{downstream}{an integer (2), relative region to get downstream from}
}
\value{
a GRanges, or GRangesList object if any group had > 1 exon.
}
\description{
Get the stop region of each ORF / region. If you want the stop codon only,
set downstream = 0 or just use \code{\link{stopCodons}}.
Standard is 2 upstream and 2 downstream, a width 5 window centered at
stop site.
}
\details{
If tx is null, then downstream will be forced to 0 and
upstream to a minimum of -grl width (to the TSS).
.
Since there is no reference for splicing.
}
\examples{
## ORF stop region
orf <- GRangesList(tx1 = GRanges("1", 200:300, "+"))
tx <- GRangesList(tx1 = GRanges("1",
                   IRanges(c(100, 305), c(300, 400)), "+"))
stopRegion(orf, tx, upstream = 6, downstream = 6)
## 2nd last codon of ORF
stopRegion(orf, tx, upstream = 6, downstream = -3)
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
