% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txdbHelpers.R
\name{makeSymbols}
\alias{makeSymbols}
\title{Make Gene symbols from txdb}
\usage{
makeSymbols(
  txdb,
  symbols_file_out_path = file.path(dirname(getGtfPathFromTxdb(txdb, stop.error = TRUE)),
    "gene_symbol_tx_table.fst"),
  uniprot_id = FALSE
)
}
\arguments{
\item{txdb}{a TxDb file, a path to one of:
(.gtf ,.gff, .gff2, .gff2, .db or .sqlite)
or an ORFik experiment}

\item{symbols_file_out_path}{path to save, default \code{file.path(dirname(getGtfPathFromTxdb(txdb, stop.error = TRUE)), "gene_symbol_tx_table.fst")}}

\item{uniprot_id}{logical default FALSE.  If TRUE, will download
and store all uniprot id for all transcripts (coding and noncoding)-
In a file called: "gene_symbol_tx_table.fst" in same folder as txdb.}
}
\value{
the data.table of tx_ids, gene_ids and gene symbols
}
\description{
Make Gene symbols from txdb
}
