% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_heatmaps.R
\name{heatMapRegion}
\alias{heatMapRegion}
\title{Create coverage heatmaps of specified region}
\usage{
heatMapRegion(
  df,
  region = "TIS",
  outdir = "default",
  scores = c("transcriptNormalized", "sum"),
  type = "ofst",
  cage = NULL,
  plot.ext = ".pdf",
  acceptedLengths = 21:75,
  upstream = c(50, 30),
  downstream = c(29, 69),
  shifting = c("5prime", "3prime"),
  longestPerGene = TRUE,
  colors = "default",
  scale_x = 5.5,
  scale_y = 15.5,
  gradient.max = "default",
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{region}{a character, default "TIS". The centering point for the heatmap
(what is position 0, beween -50 and 50 etc), can be any combination of the
 set: c("TSS", "TIS", "TTS", "TES"), which are:
 - Transcription start site (5' end of mrna)\cr
 - Translation initation site (5' end of CDS)\cr
 - Translation termination site (5' end of 3' UTRs)\cr
 - Transcription end site (3' end of 3' UTRs)\cr}

\item{outdir}{a character path, default: "default", saves to:
\code{file.path(QCfolder(df), "heatmaps/")}, a created
folder within the ORFik experiment data folder for plots. Change if you
want custom location.}

\item{scores}{character vector, default \code{c("transcriptNormalized", "sum")},
either of zscore, transcriptNormalized, sum, mean, median, ..
see ?coverageScorings for info and more alternatives.}

\item{type}{character, default: "ofst". Type of library:
either "default", usually bam format (the one you gave to experiment),
"pshifted" pshifted reads, "ofst", "bed", "bedo" optimized bed, or "wig"}

\item{cage}{a character path to library file or a \code{\link{GRanges}},
\code{\link{GAlignments}} preloaded file of CAGE data. Only used if
"TSS" is defined as region, to redefine 5' leaders.}

\item{plot.ext}{a character, default ".pdf", alternative ".png"}

\item{acceptedLengths}{an integer vector (NULL), the read lengths accepted.
Default NULL, means all lengths accepted.}

\item{upstream}{1 or 2 integers, default c(50, 30), how long upstream from 0
should window extend (first index is 5' end extension, second is 3' end extension).
If only 1 shifting, only 1 value should be given, if two are given will use first.}

\item{downstream}{1 or 2 integers, default c(29, 69), how long upstream from 0
should window extend (first index is 5' end extension, second is 3' end extension).
If only 1 shifting, only 1 value should be given, if two are given will use first.}

\item{shifting}{a character, default c("5prime", "3prime"), can also be
NULL (no shifting of reads). If NULL, will use first index of 'upstream'
and 'downstream' argument.}

\item{longestPerGene}{logical, default TRUE. Use only longest transcript
isoform per gene. This will speed up your computation.}

\item{colors}{character vector, default: "default", this gives you:
c("white", "yellow2", "yellow3", "lightblue", "blue", "navy"),
do "high" for more high contrasts, or specify your own colors.}

\item{scale_x}{numeric, how should the width of the single plots be scaled,
bigger the number, the bigger the plot}

\item{scale_y}{numeric, how should the height of the plots be scaled,
bigger the number, the bigger the plot}

\item{gradient.max}{numeric or character, default: "default", which is:
\code{max(coverage$score)}, the max coverage over all readlengths.
 If you want all plots to use same reference point
for max scaling, then first detect this point, look at max in plot etc,
and use that value, to get all plots to have same max point.}

\item{BPPARAM}{a core param, default: single thread: \code{BiocParallel::SerialParam()}.
Set to \code{BiocParallel::bpparam()} to use multicore. Be aware, this uses a lot of
extra ram (40GB+) for larger human samples!}
}
\value{
invisible(NULL), plots are saved
}
\description{
Simplified input space for easier abstraction of coverage heatmaps\cr
Pick your transcript region and plot directly \cr
Input CAGE file if you use TSS and want improved 5' annotation.
}
\examples{
# Toy example, will not give logical output, but shows how it works
df <- ORFik.template.experiment()[9:10,] # Subset to 2 Ribo-seq libs
#heatMapRegion(df, "TIS", outdir = "default")
#
# Do also TSS, add cage for specific TSS
# heatMapRegion(df, c("TSS", "TIS"), cage = "path/to/cage.bed")

# Do on pshifted reads instead of original files
remove.experiments(df) # Remove loaded experiment first
# heatMapRegion(df, "TIS", type = "pshifted")
}
\seealso{
Other heatmaps: 
\code{\link{coverageHeatMap}()},
\code{\link{heatMapL}()},
\code{\link{heatMap_single}()}
}
\concept{heatmaps}
