% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uORF_helpers.R
\name{filterUORFs}
\alias{filterUORFs}
\title{Remove uORFs that are false CDS hits}
\usage{
filterUORFs(uorfs, cds)
}
\arguments{
\item{uorfs}{(GRangesList), the uORFs to filter}

\item{cds}{(GRangesList), the coding sequences (main ORFs on transcripts),
to filter against.}
}
\value{
(GRangesList) of filtered uORFs
}
\description{
This is a strong filtering, so that even if the cds is on another transcript
, the uORF is filtered out, this is because there is no way of knowing by
current ribo-seq, rna-seq experiments.
}
\seealso{
Other uorfs: 
\code{\link{addCdsOnLeaderEnds}()},
\code{\link{removeORFsWithSameStartAsCDS}()},
\code{\link{removeORFsWithSameStopAsCDS}()},
\code{\link{removeORFsWithStartInsideCDS}()},
\code{\link{removeORFsWithinCDS}()},
\code{\link{uORFSearchSpace}()}
}
\concept{uorfs}
\keyword{internal}
