% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_footprints_helpers.R
\name{ribo_fft}
\alias{ribo_fft}
\title{Get periodogram data per read length}
\usage{
ribo_fft(footprints, cds, read_lengths = 26:34, firstN = 150)
}
\arguments{
\item{footprints}{Ribosome footprints in either \code{\link{GAlignments}} or
\code{\link{GRanges}}}

\item{cds}{a \code{\link{GRangesList}} of coding sequences. Length must match
length of argument mrna, and all must have length > arugment firstN.}

\item{read_lengths}{integer vector, default: 26:34,
which read length to check for. Will exclude all read_lengths that
does not exist for footprints.}

\item{firstN}{(integer) Represents how many bases of the transcripts
downstream of start codons to use for initial estimation of the
periodicity.}
}
\value{
a data.table with read_length, amplitude and periods
}
\description{
A data.table of periods and amplitudes, great to detect
ribosomal read lengths. Uses 5' end of reads to detect periodicity.
Works both before and after p-shifting. Plot results with ribo_fft_plot.
}
\examples{
## Note, this sample data is not intended to be strongly periodic.
## Real data should have a cleaner peak for x = 3 (periodicity)
# Load sample data
df <- ORFik.template.experiment()
# Load annotation
loadRegions(df, "cds", names.keep = filterTranscripts(df))
# Select a riboseq library
df <- df[df$libtype == "RFP", ]
footprints <- fimport(filepath(df[1,], "default"))
fft_dt <-ribo_fft(footprints, cds)
ribo_fft_plot(fft_dt)
}
