% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imports.R
\name{readBamIsUniqueMapper}
\alias{readBamIsUniqueMapper}
\title{Read unique mapper status from bam}
\usage{
readBamIsUniqueMapper(bam_paths, yieldSize = NA_integer_)
}
\arguments{
\item{bam_paths}{paths to bam files}

\item{yieldSize}{integer, default NA_integer_, number of reads to read in,
set to NA_integer_ to get full file.}
}
\value{
a list of logical elements, 1 for each bam file, TRUE is unique
mapper.
}
\description{
The 'seq' flag of the bam, with a specified number of rows
}
\examples{
df <- ORFik.template.experiment.zf()
bam_file_path <- filepath(df, "default")
readBamIsUniqueMapper(bam_file_path, 1e2)
}
