% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_helpers.R
\name{orfFrameDistributions}
\alias{orfFrameDistributions}
\title{Find shifted Ribo-seq frame distributions}
\usage{
orfFrameDistributions(
  df,
  type = "pshifted",
  weight = "score",
  orfs = loadRegion(df, part = "cds"),
  libraries = outputLibs(df, type = type, output.mode = "envirlist"),
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{type}{type of library loaded, default pshifted,
warning if not pshifted might crash if too many read lengths!}

\item{weight}{which column in reads describe duplicates, default "score".}

\item{orfs}{GRangesList, default loadRegion(df, part = "cds")}

\item{libraries}{a list of loaded libraries, default:
outputLibs(df, type = type, output.mode = "envirlist")}

\item{BPPARAM}{how many cores/threads to use? default: bpparam().
To see number of threads used, do \code{bpparam()$workers}.
You can also add a time remaining bar, for a more detailed pipeline.}
}
\value{
data.table with columns: fraction (library) frame (0, 1, 2)
score (coverage) length (read length)
   percent (coverage percentage of library)
   percent_length (coverage percentage of library and length)
   best_frame (TRUE/FALSE, is this the best frame per length)
}
\description{
Per library: get coverage over CDS per frame per readlength
Return as data.datable with information and best frame found.
Can be used to automize re-shifting of read lengths (find read lengths
where frame 0 is not the best frame over the entire cds)
}
\examples{
df <- ORFik.template.experiment()[9,]
dt <- orfFrameDistributions(df, BPPARAM = BiocParallel::SerialParam())
## Check that frame 0 is best frame for all
all(dt[frame == 0,]$best_frame)
}
