% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GO_analysis.R
\name{go_analaysis_gorilla}
\alias{go_analaysis_gorilla}
\title{GO analysis with GOrilla}
\usage{
go_analaysis_gorilla(
  target_genes,
  background_genes,
  organism,
  analysis_name = paste0("Go_analysis_", organism),
  open_browser = TRUE,
  pvalue_thresh = 0.01,
  db = "all"
)
}
\arguments{
\item{target_genes}{a path to a txt file with the target Gene symbols,
or presumed to be a character vector of genes (if length > 1).
Minimum 10 genes, maximum 1 million.}

\item{background_genes}{a path to a txt file with the background Gene symbols,
or presumed to be a character vector of genes (if length > 1).
Minimum 10 genes, maximum 2 million.}

\item{organism}{organism(df), example "Homo sapiens"}

\item{analysis_name}{character name, default "test".
Used for saved file names and analysis name in GOrilla.}

\item{open_browser}{= TRUE, open the URL}

\item{pvalue_thresh}{fixed set numeric, default 0.001, Alternatives: 10e-3 to 10e-11}

\item{db}{character, default "all". Which GO onthology categories to use,
all means process, function and component.
Alternatives: "proc", "func" and "comp", if you only want that single category subset.}
}
\value{
a url path to results, will also open your default web browser if open_browser
is TRUE.
}
\description{
Supports Gene symbols as default, and will produce the best
results.
You can also use ensembl gene ids, refseq gene ids and Entrez gene
ids, but this will give weaker results.
}
\examples{
target_genes <- system.file("extdata/Homo_sapiens_sample/QC_STATS",
  "/DTEG_Comparison_Translation.txt", package = "ORFik")
background_genes <- system.file("extdata/Homo_sapiens_sample/QC_STATS",
  "/DTEG_Comparison_Background.txt", package = "ORFik")
#go_analaysis_gorilla(target_genes, background_genes, "Homo sapiens",
#                     analysis_name = "Translation vs background")
}
\references{
https://bmcbioinformatics.biomedcentral.com/articles/10.1186/1471-2105-10-48
}
