% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_heatmaps.R
\name{coverageHeatMap}
\alias{coverageHeatMap}
\title{Create a heatmap of coverage}
\usage{
coverageHeatMap(
  coverage,
  output = NULL,
  scoring = "zscore",
  legendPos = "right",
  addFracPlot = FALSE,
  xlab = "Position relative to start site",
  ylab = "Protected fragment length",
  colors = "default",
  title = NULL,
  increments.y = "auto",
  gradient.max = max(coverage$score)
)
}
\arguments{
\item{coverage}{a data.table, e.g. output of scaledWindowCoverage}

\item{output}{character string (NULL), if set, saves the plot as pdf or png
to path given. If no format is given, is save as pdf.}

\item{scoring}{character vector, default "zscore",
Which scoring did you use to create? either of zscore,
transcriptNormalized, sum, mean, median, ..
see ?coverageScorings for info and more alternatives.}

\item{legendPos}{a character, Default "right". Where should the fill legend
be ? ("top", "bottom", "right", "left")}

\item{addFracPlot}{Add margin histogram plot on top of heatmap with
fractions per positions}

\item{xlab}{the x-axis label, default "Position relative to start site"}

\item{ylab}{the y-axis label, default "Protected fragment length"}

\item{colors}{character vector, default: "default", this gives you:
c("white", "yellow2", "yellow3", "lightblue", "blue", "navy"),
do "high" for more high contrasts, or specify your own colors.}

\item{title}{a character, default NULL (no title),
what is the top title of plot?}

\item{increments.y}{increments of y axis, default "auto".
Or a numeric value < max position & > min position.}

\item{gradient.max}{numeric, defualt: max(coverage$score). What data value
should the top color be ? Good to use if you want to compare 2 samples, with the
same color intensity, in that case set this value to the max score of the
2 coverage tables.}
}
\value{
a ggplot object of the coverage plot, NULL if output is set,
then the plot will only be saved to location.
}
\description{
Creates a ggplot representing a heatmap of coverage:\cr
\itemize{
 \item{Rows : Position in region}
 \item{Columns : Read length}
 \item{Index intensity : (color) coverage scoring per index.}
}
Coverage rows in heat map is fraction, usually fractions is divided into
unique read lengths (standard Illumina is 76 unique widths, with some
minimum cutoff like 15.)
Coverage column in heat map is score, default zscore of counts. These are
the relative positions you are plotting to. Like +/- relative to TIS or TSS.
}
\details{
Colors:
Remember if you want to change anything like colors, just return the
ggplot object, and reassign like: obj + scale_color_brewer() etc.
Standard colors are:\cr
\itemize{
 \item{0 reads in whole readlength : gray}
 \item{few reads in position : white}
 \item{medium reads in position : yellow}
 \item{many reads in position : dark blue}
}
}
\examples{
# An ORF
grl <- GRangesList(tx1 = GRanges("1", IRanges(1, 6), "+"))
# Ribo-seq reads
range <- IRanges(c(rep(1, 3), 2, 3, rep(4, 2), 5, 6), width = 1 )
reads <- GRanges("1", range, "+")
reads$size <- c(rep(28, 5), rep(29, 4)) # read size
coverage <- windowPerReadLength(grl, reads = reads, upstream = 0,
                                downstream = 5)

coverageHeatMap(coverage)

# With top sum bar
coverageHeatMap(coverage, addFracPlot = TRUE)
# See vignette for more examples

}
\seealso{
Other heatmaps: 
\code{\link{heatMapL}()},
\code{\link{heatMapRegion}()},
\code{\link{heatMap_single}()}

Other coveragePlot: 
\code{\link{pSitePlot}()},
\code{\link{savePlot}()},
\code{\link{windowCoveragePlot}()}
}
\concept{coveragePlot}
\concept{heatmaps}
