% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_Features.R
\name{computeFeatures}
\alias{computeFeatures}
\title{Get all main features in ORFik}
\usage{
computeFeatures(
  grl,
  RFP,
  RNA = NULL,
  Gtf,
  faFile = NULL,
  riboStart = 26,
  riboStop = 34,
  sequenceFeatures = TRUE,
  uorfFeatures = TRUE,
  grl.is.sorted = FALSE,
  weight.RFP = 1L,
  weight.RNA = 1L
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object
with usually ORFs, but can also be either leaders, cds', 3' utrs, etc.
This is the regions you want to score.}

\item{RFP}{RiboSeq reads as \code{\link{GAlignments}} , \code{\link{GRanges}}
or \code{\link{GRangesList}} object}

\item{RNA}{RnaSeq reads as \code{\link{GAlignments}} , \code{\link{GRanges}}
or \code{\link{GRangesList}} object}

\item{Gtf}{a TxDb object of a gtf file or path to gtf, gff .sqlite etc.}

\item{faFile}{a path to fasta indexed genome, an open \code{\link{FaFile}},
a BSgenome, or path to ORFik \code{\link{experiment}} with valid genome.}

\item{riboStart}{usually 26, the start of the floss interval, see ?floss}

\item{riboStop}{usually 34, the end of the floss interval}

\item{sequenceFeatures}{a logical, default TRUE, include all sequence
features, that is: Kozak, fractionLengths, distORFCDS, isInFrame,
isOverlapping and rankInTx. uorfFeatures = FALSE will remove the 4 last.}

\item{uorfFeatures}{a logical, default TRUE, include all uORF sequence
features, that is: distORFCDS, isInFrame, isOverlapping and rankInTx}

\item{grl.is.sorted}{logical (F), a speed up if you know argument grl
is sorted, set this to TRUE.}

\item{weight.RFP}{a vector (default: 1L). Can also be character name of
column in RFP. As in translationalEff(weight = "score") for:
GRanges("chr1", 1, "+", score = 5), would mean score column tells
that this alignment region was found 5 times.}

\item{weight.RNA}{Same as weightRFP but for RNA weights.
(default: 1L)}
}
\value{
a data.table with scores, each column is one score type, name of
columns are the names of the scores, i.g [floss()]
or [fpkm()]
}
\description{
If you want to get all the NGS and/or sequence features easily,
you can use this function.
Each feature have a link to an article describing its creation and idea
behind it. Look at the functions in the feature family (in the "see also" section below)
to see all of them. Example, if you want to know what the "te" column is, check out:
?translationalEff.\cr
A short description of each feature is also shown here:\cr\cr
** \strong{NGS features} **
If not stated otherwise stated, the feature apply to Ribo-seq.
\itemize{
 \item{countRFP : raw counts of Ribo-seq}
 \item{fpkmRFP : FPKM}
 \item{fpkmRNA : FPKM of RNA-seq}
 \item{te : Translation efficiency Ribo-seq / RNA-seq FPKM}
 \item{floss : Fragment length similarity score}
 \item{entropyRFP : Positional entropy}
 \item{disengagementScores : downstream coverage from ORF}
 \item{RRS : Ribosome release score}
 \item{RSS : Ribosome staling score}
 \item{ORFScores : Periodicity score, does frame 0 have more reads}
 \item{ioScore : inside outside score: coverage ORF / coverage rest of transcript}
 \item{startCodonCoverage : Coverage over start codon + 2nt before start codon}
 \item{startRegionCoverage : Coverage over codon 2 & 3}
 \item{startRegionRelative : Peakness of TIS, startCodonCoverage / startRegionCoverage, 0-n}
}
** \strong{Sequence features} **
\itemize{
 \item{kozak : Similarity to kozak sequence for organism score, 0-1}
 \item{gc : GC percentage, 0-1}
 \item{StartCodons : Start codon as a string, "ATG"}
 \item{StopCodons : stop codon as a string, "TAA"}
 \item{fractionLengths : ORF length compared to transcript, 0-1}
}
** \strong{uORF features} **
\itemize{
 \item{distORFCDS : Distance from ORF stop site to CDS, -n:n}
 \item{inFrameCDS : Is ORF in frame with downstream CDS, T/F}
 \item{isOverlappingCds : Is ORF overlapping with downstream CDS, T/F}
 \item{rankInTx : ORF with most upstream start codon is 1, 1-n}
}
}
\details{
If you used CageSeq to reannotate your leaders, your txDB object must
contain the reassigned leaders. Use [reassignTxDbByCage()] to get the txdb.\cr
As a note the library is reduced to only reads overlapping 'tx', so the
library size in fpkm calculation is done on this subset. This will help
remove rRNA and other contaminants.\cr
Also if you have only unique reads with a weight column, explaining the
number of duplicated reads, set weights to make calculations correct.
See \code{\link{getWeights}}
}
\examples{
# Here we make an example from scratch
# Usually the ORFs are found in orfik, which makes names for you etc.
gtf <- system.file("extdata/references/danio_rerio", "annotations.gtf",
 package = "ORFik") ## location of the gtf file

suppressWarnings(txdb <- loadTxdb(gtf))
# use cds' as ORFs for this example
ORFs <- loadRegion(txdb, "cds")
ORFs <- makeORFNames(ORFs) # need ORF names
# make Ribo-seq data,
RFP <- unlistGrl(firstExonPerGroup(ORFs))
computeFeatures(ORFs, RFP, Gtf = txdb)
# For more details see vignettes.

}
\seealso{
Other features: 
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
