% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_footprints_helpers.R
\name{changePointAnalysis}
\alias{changePointAnalysis}
\title{Get the offset for specific RiboSeq read width}
\usage{
changePointAnalysis(
  x,
  feature = "start",
  max.pos = 40L,
  interval = seq.int(14L, 24L),
  center.pos = 12,
  info = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x}{a vector with count per position to analyse, assumes the zero
position (TIS) is in the middle + 1 (position 0). Default it is size 60,
from -30 to 29 in p-shifting}

\item{feature}{(character) either "start" or "stop"}

\item{max.pos}{integer, default 40L, subset x to go from index 1 to max.pos,
if tail is not relevant.}

\item{interval}{integer vector , default seq.int(14L, 24L).
The possible shift locations, default
Seperation points for upstream and downstream windows.
That is (+/- 5 from -12) position.}

\item{center.pos}{integer, default 12. Centering position for likely p-site.
A first qualified guess to save time. 12 means 12 bases before TIS.}

\item{info}{specify read length if wanted for verbose output.}

\item{verbose}{logical, default FALSE. Report details of change point analysis.}
}
\value{
a single numeric offset, -12 would mean p-site is 12 bases upstream
}
\description{
Creates sliding windows of transcript normalized counts per position
and check which window has most in upstream window vs downstream window.
Pick the position with highest absolute value maximum of the window difference.
Checks windows with split sites between positions -17 to -7, where 0 is TIS.
Normally you expect the shift around -12 for Ribo-seq, in TCP-seq / RCP-seq
it is usually a bit higher, usually because of cross-linking variations.
}
\details{
For visual explanation, see the supl. data of ORFik paper:
Transcript normalized means per CDS TIS region, count reads per position,
divide that number per position by the total of that transcript, then sum
up these numbers per position for all transcripts.
}
\seealso{
Other pshifting: 
\code{\link{detectRibosomeShifts}()},
\code{\link{shiftFootprints}()},
\code{\link{shiftFootprintsByExperiment}()},
\code{\link{shiftPlots}()},
\code{\link{shifts_load}()},
\code{\link{shifts_save}()}
}
\concept{pshifting}
\keyword{internal}
