% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_helpers.R
\name{appendZeroes}
\alias{appendZeroes}
\title{Append zero values to data.table}
\usage{
appendZeroes(dt, max.pos, min.pos = 1L, fractions = unique(dt$fraction))
}
\arguments{
\item{dt}{a data.table from coverageByTiling that is
normalized by coverageScorings.}

\item{max.pos}{integer, max position of dt}

\item{min.pos}{integer, default 1L. Minimum position of dt}

\item{fractions}{default unique(dt$fraction), will repeat
each fraction max.pos - min.pos + 1 times.}
}
\value{
a data.table with appended 0 values
}
\description{
For every position in width max.pos - min.pos + 1, append
0 values in data.table. Needed when coveragePerTiling was run
on coverage window with drop.zero.dt as TRUE and you need to plot
0 positions after a transformation by coverageScorings.
}
\keyword{internal}
