% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_rank_givenEffect_exact.R
\name{prob_rank_givenEffect_exact}
\alias{prob_rank_givenEffect_exact}
\title{Probability of rank of test given effect size by exact method}
\usage{
prob_rank_givenEffect_exact(k, et, ey, nrep = 10000, m0, m1,
  effectType = c("binary", "continuous"))
}
\arguments{
\item{k}{Integer, rank of a test}

\item{et}{Numeric, effect of the targeted test for importance sampling}

\item{ey}{Numeric, mean/median filter efffect from external information}

\item{nrep}{Integer, number of replications for importance sampling}

\item{m0}{Integer, number of true null hypothesis}

\item{m1}{Integer, number of true alternative hypothesis}

\item{effectType}{Character ("continuous" or "binary"), type of effect sizes}
}
\value{
\code{prob} Numeric, probability of the rank of a test
}
\description{
An exact method to comnpute the probability of rank of a
test being higher than any other test given the effect size from external
information.
}
\details{
If one wants to test \deqn{H_0: epsilon_i=0 vs. H_a: epsilon_i > 0,}
then \code{ey} should be mean of the filter effect sizes,
This is called hypothesis testing for the continuous effect sizes.\cr

If one wants to test \deqn{H_0: epsilon_i=0 vs. H_a: epsilon_i = epsilon,}
then \code{ey} should be median or any discrete value of the
filter effect sizes. This is called hypothesis testing for the Binary
effect sizes.\cr

\code{m1} and \code{m0} can be estimated using \code{qvalue} from
a bioconductor package \code{qvalue}.
}
\examples{
# compute the probability of the rank of a test being third if all tests are
# from the true null
prob <- prob_rank_givenEffect_exact(k=3, et=0, ey=0, nrep=10000, m0=50, m1=50,
                                effectType= "continuous")

# compute the probabilities of the ranks of a test being rank 1 to 100 if the
# targeted test effect is 2 and the overall mean filter effect is 1.
ranks <- 1:100
prob <- sapply(ranks, prob_rank_givenEffect, et = 2, ey = 1, nrep = 10000,
                              m0 = 50, m1 = 50)

# plot
plot(ranks, prob)

}
\seealso{
\code{\link{dnorm}} \code{\link{pnorm}} \code{\link{rnorm}}
\code{\link{qvalue}}
}
\author{
Mohamad S. Hasan, shakilmohamad7@gmail.com
}
