% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{gvizPlot}
\alias{gvizPlot}
\title{Generate Gviz plot}
\usage{
gvizPlot(
  OGREDataSet,
  query,
  gvizPlotsFolder = metadata(OGREDataSet)$gvizPlotsFolder,
  trackRegionLabels = setNames(rep("ID", length(OGREDataSet)), names(OGREDataSet)),
  trackShapes = setNames(rep("fixedArrow", length(OGREDataSet)), names(OGREDataSet)),
  showPlot = FALSE,
  extendPlot = c(-300, 300),
  nElements = 25
)
}
\arguments{
\item{OGREDataSet}{A OGREDataSet.}

\item{query}{A character vector of one or many query elements ID's (i.e. Gene ID's).}

\item{gvizPlotsFolder}{A character pointing to the plot(s) output directory.
If not supplied a folder is automatically generated and can be accessed by
\code{metatdata(OGREDataSet)$gvizPlotsFolder}.}

\item{trackRegionLabels}{A labeled character vector that defines the type of
label that is displayed for query and subject elements during plotting.
Vector values represent the type of label and vector labels define the type
of subject element. In the following example
\code{setNames(c("ID","name"),c("genes","CGI"))}
Value "ID" and label "genes" would annotate your genes with IDs taken from the
ID column of your dataset. Datasets not defined in this vector are
plotted without track labels.}

\item{trackShapes}{A labeled character vector that defines the type of
shape in which every dataset's elements are displayed.
Vector values represent the type of shape and vector labels define the type
of subject element. In the following example
\code{setNames(c("fixedArrow","box"),c("genes","CGI"))}
Value "fixedArrow" and label "genes" would display your genes in fixedArrow
and CGI as box shape. Possible values:
(box, arrow, fixedArrow, ellipse, and smallArrow) Default="fixedArrow"}

\item{showPlot}{\code{logical} If \code{FALSE}(default) plots are only saved
to \code{gvizPlotsFolder}. If \code{TRUE}
plots are additionally send to the plotting window.}

\item{extendPlot}{\code{int vector} Integer vector of length two that extends
the plot window to the left or right by adding the first value to query start
and the second value to query end coordinates(bp). e.g. \code{c(-1000,1000)}
zooms out, \code{c(1000,-1000)} zooms in and \code{c(-1000,0)} shifts the plot
window to the left.}

\item{nElements}{\code{integer} Number of elements that are displayed
in each track (Default=25). High n.elements can lead to overplotting. Use
\code{nElements=FALSE} to display all elements.}
}
\value{
OGREDataSet.
}
\description{
\code{gvizPlot} generates a plot around one or many given query elements with all
overlapping subject hits. In addition, each generated plot can be stored in
the \code{gvizPlots} folder get or set by \code{gvizPlotsFolder}. A maximum of 25
elements can be plotted per track.
}
\examples{
myOGRE <- makeExampleOGREDataSet()
myOGRE <- loadAnnotations(myOGRE)
myOGRE <- fOverlaps(myOGRE)
myOGRE <- gvizPlot(myOGRE,query="ENSG00000142168")
}
