% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biotypeOperations.R
\name{extractBiotype}
\alias{extractBiotype}
\title{Get the biotype of the non-coding genes. It is suitable for the
GENCODE gtf files}
\usage{
extractBiotype(gtfFile)
}
\arguments{
\item{gtfFile}{Path of the input gtf file which contains biotype
information. The gtf file must be provided from the Ensembl
or Gencode site. For space efficiency, gft files should be
in a zip format.}
}
\value{
Tabular form of the gtf file with the required features
  such as gene id and biotypes
}
\description{
Get the biotype of the non-coding genes. It is suitable for the
GENCODE gtf files
}
\examples{
\dontrun{
fileImport<-system.file("extdata", "temp.gtf", package = "NoRCE")
gtf <- extractBiotype(gtfFile = fileImport)
}

}
