% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/helper_methods.R
\name{newAIC}
\alias{newAIC}
\alias{newAIC,newmodel,matrix-method}
\title{Compute the AIC of a model given some data}
\usage{
newAIC(model, x)

\S4method{newAIC}{newmodel,matrix}(model, x)
}
\arguments{
\item{model}{an object that describes a statistical model.}

\item{x}{an object that describes data.}
}
\value{
the AIC of the model.
}
\description{
Given a statistical model and some data, this function computes the AIC
of the model given the data, i.e., the AIC of the data under the model.
}
\section{Functions}{
\itemize{
\item \code{newAIC,newmodel,matrix-method}: returns the AIC of the NB model.
}}

\examples{
m <- newmodel(n=5, J=10)
x <- newSim(m)
newAIC(m, x$counts)
}
