% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupedGSEAtoStackedReport.R
\name{groupedGSEAtoStackedReport}
\alias{groupedGSEAtoStackedReport}
\title{Build a report from gene set enrichment results.}
\usage{
groupedGSEAtoStackedReport(grouped.gsea, leadingEdge, de.fit, outputDir = NULL)
}
\arguments{
\item{grouped.gsea}{Output from groupFGSEA()}

\item{leadingEdge}{Leading edge analysis results used in groupFGSEA()}

\item{de.fit}{Differential Expression results from Limma or NanoStringDiff}

\item{outputDir}{Directory for output files. If NULL (default), will return
the stacked report instead of writing to a file.}
}
\value{
A stacked report containing statistics and gene expression profiles
for genes contained in each cluster
}
\description{
After clustering FGSEA results by gene set similarity, this function builds
a report containing the individual gene expression profiles for genes 
contained in each gene set cluster.
}
\examples{
data("ExamplePathways")
data("ExampleResults") # Results from runLimmaAnalysis

fgseaResults <- limmaToFGSEA(ExampleResults, gene.sets = ExamplePathways,
                             min.set = 5, rank.by = "t")
leadingEdge <- fgseaToLEdge(fgseaResults, cutoff.type = "padj", cutoff = 0.1)

fgseaGrouped <- groupFGSEA(fgseaResults$Autoimmune.retinopathy, 
                            leadingEdge$Autoimmune.retinopathy,
                            join.threshold = 0.5,
                            dist.method = "binary")

results.AR <- groupedGSEAtoStackedReport(
              fgseaGrouped,
              leadingEdge = leadingEdge$Autoimmune.retinopathy,
              de.fit = ExampleResults)
}
