% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_dictionary.R
\name{column_dictionary}
\alias{column_dictionary}
\title{Map column names to positions.}
\source{
Borrowed function from
\href{https://github.com/RajLabMSSM/echotabix/blob/main/R/convert.R}{
echotabix}.

\code{
eduAttainOkbayPth <- system.file("extdata", "eduAttainOkbay.txt",
    package = "MungeSumstats"
)
tmp <- tempfile(fileext = ".tsv")
file.copy(eduAttainOkbayPth, tmp)
cdict <- MungeSumstats:::column_dictionary(file_path = tmp)
}
}
\usage{
column_dictionary(file_path)
}
\arguments{
\item{file_path}{Path to full summary stats file
(or any really file you want to make a column dictionary for).}
}
\value{
Named list of column positions.
}
\description{
Useful in situations where you need to specify columns by
index instead of name (e.g. awk queries).
}
\keyword{internal}
