% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{add_genexp}
\alias{add_genexp}
\title{Method to add an expression microarray dataset to \code{MultiDataSet}.}
\usage{
add_genexp(object, gexpSet, ...)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filled.}

\item{gexpSet}{\code{ExpressionSet} to be used to fill the slot.}

\item{...}{Arguments to be passed to \code{add_eset}.}
}
\value{
A new \code{MultiDataSet} with the slot \code{"expression"}
filled.
}
\description{
This method adds or overwrites the slot \code{"expression"} of an
\code{MultiDataSet} with the content of the given \code{ExpressionSet}. The fData of 
the \code{ExpressionSet} must contain the columns chromosome, start and end.
}
\examples{
multi <- createMultiDataSet()
eset <- new("ExpressionSet", exprs = matrix(runif(4), 2))
fData(eset) <- data.frame(chromosome = c("chr1", "chr2"), start = c(12414, 1234321),
 end = c(121241, 124124114), stringsAsFactors = FALSE)
multi <- add_genexp(multi, eset)
}
