% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{explained_varPlot}
\alias{explained_varPlot}
\title{explained_varPlot}
\usage{
explained_varPlot(mbac, ...)
}
\arguments{
\item{mbac}{Object of class mbac generated by *ARSyNbac*, *MultiBaC* or *batchCorrection*.}

\item{...}{Other graphical parameters.}
}
\value{
Explained variance plot for ARSyN models is displayed.
}
\description{
explained_varPlot
}
\examples{
data('multiyeast')

my_mbac <- createMbac (inputOmics = list(A.rna, A.gro, B.rna, B.ribo, C.rna, C.par),
                       batchFactor = c("A", "A", "B", "B", "C", "C"),
                       experimentalDesign = list("A" =  c("Glu+", "Glu+",
                       "Glu+", "Glu-", "Glu-", "Glu-"),
                       "B" = c("Glu+", "Glu+", "Glu-", "Glu-"),
                       "C" = c("Glu+", "Glu+", "Glu-", "Glu-")),
                       omicNames = c("RNA", "GRO", "RNA", "RIBO", "RNA", "PAR"))

my_final_mbac <- MultiBaC (my_mbac,
                           test.comp = NULL, scale = FALSE,
                           center = TRUE, crossval = NULL,
                           Variability = 0.90,
                           Interaction = TRUE ,
                           showplot = FALSE,
                           showinfo = FALSE)

explained_varPlot (my_final_mbac)

}
