% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_h5mu.R
\name{readH5AD}
\alias{readH5AD}
\title{Read an .h5ad file and create a \code{\linkS4class{SingleCellExperiment}}.}
\usage{
readH5AD(file, backed = FALSE)
}
\arguments{
\item{file}{Path to the .h5ad file.}

\item{backed}{Whether to use file-backed mode.}
}
\value{
A \code{\linkS4class{SingleCellExperiment}}.
}
\description{
In file-backed mode, the main \code{X} matrix is not read into memory,
but references the HDF5 file and its required parts are read on demand.
This requires the HDF5Array package to be installed.
}
\examples{
data(miniACC, package="MultiAssayExperiment")
writeH5AD(miniACC[[1]], "miniacc.h5ad")
sce <- readH5AD("miniacc.h5ad")

}
