% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i2index.R
\name{i2index}
\alias{i2index}
\title{Input parameter check for subsetting operations}
\usage{
i2index(i, length = length(i), names = NULL)
}
\arguments{
\item{i}{\code{character} \code{logical} or \code{integer} used in \verb{[i]} for subsetting.}

\item{length}{\code{integer} representing the \code{length} of the object to be
subsetted.}

\item{names}{\code{character} with the names (rownames or similar) of the object.
This is only required if \code{i} is of type \code{character}.}
}
\value{
\code{integer} with the indices
}
\description{
\code{i2index} is a simple helper function to be used in subsetting functions. It
checks and converts the parameter \code{i}, which can be of type \code{integer},
\code{logical} or \code{character} to integer vector that can be used as index for
subsetting.
}
\examples{

## With `i` being an `integer`
i2index(c(4, 1, 3), length = 10)

## With `i` being a `logical`
i2index(c(TRUE, FALSE, FALSE, TRUE, FALSE), length = 5)

## With `i` being a `character`
i2index(c("b", "a", "d"), length = 5, names = c("a", "b", "c", "d", "e"))
}
\author{
Johannes Rainer
}
