% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_df_enrichment.R
\name{get_df_enrichment}
\alias{get_df_enrichment}
\title{Get dataframe with motif enrichment values}
\usage{
get_df_enrichment(
  result,
  segregated_peaks,
  user_motifs,
  genome_build,
  reference_index = 1,
  out_dir = tempdir(),
  BPPARAM = BiocParallel::bpparam(),
  meme_path = NULL,
  verbose = FALSE
)
}
\arguments{
\item{result}{A \code{list} with the following elements:
\describe{
    \item{peaks}{A \code{list} of peak files generated using
\code{\link{read_peak_file}}.}
    \item{alignments}{A \code{list} of alignment files.}
    \item{exp_type}{A \code{character} vector of experiment types.}
    \item{exp_labels}{A \code{character} vector of experiment labels.}
    \item{read_count}{A \code{numeric} vector of read counts.}
    \item{peak_count}{A \code{numeric} vector of peak counts.}
}}

\item{segregated_peaks}{A \code{list} object generated using
\code{\link{segregate_seqs}}.}

\item{user_motifs}{A \code{list} with the following elements:
\describe{
    \item{motifs}{A \code{list} of motif files.}
    \item{motif_labels}{A \code{character} vector of motif labels.}
}}

\item{genome_build}{A character string with the abbreviated genome build
name, or a BSGenome object. At the moment, only \code{hg38} and \code{hg19}
are supported as abbreviated input.}

\item{reference_index}{An integer specifying the index of the peak file to
use as the reference dataset for comparison. Indexing starts from 1.
(default = 1)}

\item{out_dir}{A \code{character} vector of output directory.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam-class}} object
enabling parallel execution. (default = SerialParam(), single-CPU run)\cr\cr
Following are two examples of how to set up parallel processing:
\itemize{
  \item \code{BPPARAM = BiocParallel::MulticoreParam(4)}: Uses 4
  CPU cores for parallel processing.
  \item \code{library("BiocParallel")} followed by
  \code{register(MulticoreParam(4))} sets all subsequent BiocParallel
  functions to use 4 CPU cores. \code{Motifpeeker()} must be run
  with \code{BPPARAM = BiocParallel::MulticoreParam()}.
}
\strong{IMPORTANT:} For each worker, please ensure a minimum of 8GB of
memory (RAM) is available as \code{motif_discovery} is
memory-intensive.}

\item{meme_path}{path to \verb{meme/bin/} (optional). Defaut: \code{NULL}, searches
"MEME_PATH" environment variable or "meme_path" option for path to "meme/bin/".}

\item{verbose}{A logical indicating whether to print verbose messages while
running the function. (default = FALSE)}
}
\value{
A \code{data.frame} with the following columns:
\describe{
 \item{exp_label}{Experiment labels.}
 \item{exp_type}{Experiment types.}
 \item{motif_indice}{Motif indices.}
 \item{group1}{Segregated group- "all", "Common" or "Unique".}
 \item{group2}{"reference" or "comparison" group.}
 \item{count_enriched}{Number of peaks with motif.}
 \item{count_nonenriched}{Number of peaks without motif.}
 \item{perc_enriched}{Percentage of peaks with motif.}
 \item{perc_nonenriched}{Percentage of peaks without motif.}
}
}
\description{
Wrapper for `MotifPeeker::motif_enrichment` to get motif enrichment counts
and percentages for all peaks and motifs, generating a \code{data.frame}
suitable for plots. The \code{data.frame} contains values for all and
segregated peaks.
}
\examples{
if (memes::meme_is_installed()) {
    data("CTCF_ChIP_peaks", package = "MotifPeeker")
    data("CTCF_TIP_peaks", package = "MotifPeeker")
    data("motif_MA1102.3", package = "MotifPeeker")
    data("motif_MA1930.2", package = "MotifPeeker")
    input <- list(
        peaks = list(CTCF_ChIP_peaks, CTCF_TIP_peaks),
        exp_type = c("ChIP", "TIP"),
        exp_labels = c("CTCF_ChIP", "CTCF_TIP"),
        read_count = c(150, 200),
        peak_count = c(100, 120)
    )
    segregated_input <- segregate_seqs(input$peaks[[1]], input$peaks[[2]])
    motifs <- list(
        motifs = list(motif_MA1930.2, motif_MA1102.3),
        motif_labels = list("MA1930.2", "MA1102.3")
    )
    reference_index <- 1

    if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38")) {
        genome_build <-
            BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38
    
        enrichment_df <- get_df_enrichment(
            input, segregated_input, motifs, genome_build,
            reference_index = 1
        )
    }
}

}
\seealso{
Other generate data.frames: 
\code{\link{get_df_distances}()}
}
\concept{generate data.frames}
