% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_df_distances.R
\name{get_df_distances}
\alias{get_df_distances}
\title{Get dataframe with motif-summit distances}
\usage{
get_df_distances(
  result,
  user_motifs,
  genome_build,
  out_dir = tempdir(),
  BPPARAM = BiocParallel::bpparam(),
  meme_path = NULL,
  verbose = FALSE
)
}
\arguments{
\item{result}{A \code{list} with the following elements:
\describe{
    \item{peaks}{A \code{list} of peak files generated using
\code{\link{read_peak_file}}.}
    \item{alignments}{A \code{list} of alignment files.}
    \item{exp_type}{A \code{character} vector of experiment types.}
    \item{exp_labels}{A \code{character} vector of experiment labels.}
    \item{read_count}{A \code{numeric} vector of read counts.}
    \item{peak_count}{A \code{numeric} vector of peak counts.}
}}

\item{user_motifs}{A \code{list} with the following elements:
\describe{
    \item{motifs}{A \code{list} of motif files.}
    \item{motif_labels}{A \code{character} vector of motif labels.}
}}

\item{genome_build}{A character string with the abbreviated genome build
name, or a BSGenome object. At the moment, only \code{hg38} and \code{hg19}
are supported as abbreviated input.}

\item{out_dir}{A \code{character} vector of output directory.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam-class}} object
enabling parallel execution. (default = SerialParam(), single-CPU run)\cr\cr
Following are two examples of how to set up parallel processing:
\itemize{
  \item \code{BPPARAM = BiocParallel::MulticoreParam(4)}: Uses 4
  CPU cores for parallel processing.
  \item \code{library("BiocParallel")} followed by
  \code{register(MulticoreParam(4))} sets all subsequent BiocParallel
  functions to use 4 CPU cores. \code{Motifpeeker()} must be run
  with \code{BPPARAM = BiocParallel::MulticoreParam()}.
}
\strong{IMPORTANT:} For each worker, please ensure a minimum of 8GB of
memory (RAM) is available as \code{motif_discovery} is
memory-intensive.}

\item{meme_path}{path to \verb{meme/bin/} (optional). Defaut: \code{NULL}, searches
"MEME_PATH" environment variable or "meme_path" option for path to "meme/bin/".}

\item{verbose}{A logical indicating whether to print verbose messages while
running the function. (default = FALSE)}
}
\value{
A \code{data.frame} with the following columns:
\describe{
 \item{exp_label}{Experiment labels.}
 \item{exp_type}{Experiment types.}
 \item{motif_indice}{Motif indices.}
 \item{distance}{Distances between peak summit and motif.}
}
}
\description{
Wrapper for `MotifPeeker::summit_to_motif` to get motif-summit distances
for all peaks and motifs, generating a \code{data.frame} suitable
for plots.
}
\examples{
if (memes::meme_is_installed()) {
data("CTCF_ChIP_peaks", package = "MotifPeeker")
data("motif_MA1102.3", package = "MotifPeeker")
data("motif_MA1930.2", package = "MotifPeeker")
input <- list(
    peaks = CTCF_ChIP_peaks,
    exp_type = "ChIP",
    exp_labels = "CTCF",
    read_count = 150,
    peak_count = 100
)
motifs <- list(
    motifs = list(motif_MA1930.2, motif_MA1102.3),
    motif_labels = list("MA1930.2", "MA1102.3")
)

if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38")) {
    genome_build <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38
    distances_df <- get_df_distances(input, motifs, genome_build)
    print(distances_df)
}
}

}
\seealso{
Other generate data.frames: 
\code{\link{get_df_enrichment}()}
}
\concept{generate data.frames}
