% Generated manually by Peyman Zarrineh
\name{data}
\alias{data}
\title{Synthetic datasets used in the package}
\format{
Three bed files to compare user provided motifs and binding sites in Yeast.
Seven bed files to compare Fur ChIP-seq binding sites in E.coli.
\describe{
\item{YeastBedFile1.bed}{The first synthetic motif set}

\item{YeastBedFile2.bed}{The second synthetic motif set}

\item{YeastSampleMotif.bed}{The synthetic binding region}

\item{FurMotifs.bed}{User provided Fur motif set in E. coli}

\item{FUR_fe1.bed}{Synthetic Fur ChIP-seq short reads in fe condition rep1}

\item{FUR_fe2.bed}{Synthetic Fur ChIP-seq short reads in fe condition rep2}

\item{FUR_dpd1.bed}{Synthetic Fur ChIP-seq short reads in dpd condition rep1}

\item{FUR_dpd2.bed}{Synthetic Fur ChIP-seq short reads in dpd condition rep2}

\item{Input1.bed}{The synthetic background Input ChIP-seq rep1}

\item{Input2.bed}{The synthetic background Input ChIP-seq rep2}
}
}
\description{
Comparison Yeast synthetic motifs and binding sites:
Two synthetic motif files in bed fromat are created to compare them with
a synthetic binding site set in terms of precision and recall.

Fur binding sites detection in E. coli build NC_000913:
Synthetic Fur ChIp-seq in E. coli was generated using real peaks published in
Seo et al 2014. The ChIP-seq data are provided in bed format in fe and dpd
condition and both contains two replicates. Synthetic Input ChIP-seq datasets
were generated by randomly distributing short reads in E. coli genome. User
provided candidate binding sites in bed format was generated by combining
instances of "GWWTGANAA" motif with 1-mistmatch and "GWWTGAGAAT" with
2-mismatches in E. coli genome.
}
\examples{

## Data for examplex to compare user provided motifs and binding sites in Yeast 

yeastExampleFile=system.file("extdata", "YeastSampleMotif.bed",
                              package="Motif2Site")
YeastRegionsChIPseq <- Bed2Granges(yeastExampleFile)
bed1 <- system.file("extdata", "YeastBedFile1.bed", package="Motif2Site")
bed2 <- system.file("extdata", "YeastBedFile2.bed", package="Motif2Site")


## Data for examples of binding site detection in E. coli

# FUR candidate motifs in NC_000913 E. coli
FurMotifs = system.file("extdata", "FurMotifs.bed", package="Motif2Site")

# ChIP-seq FUR fe datasets binding sites from user provided bed file 
# ChIP-seq datasets in bed single end format

IPFe <- c(system.file("extdata", "FUR_fe1.bed", package="Motif2Site"),
          system.file("extdata", "FUR_fe2.bed", package="Motif2Site"))


# ChIP-seq FUR dpd datasets binding sites from user provided bed file 
# ChIP-seq datasets in bed single end format

IPDpd <- c(system.file("extdata", "FUR_dpd1.bed", package="Motif2Site"),
           system.file("extdata", "FUR_dpd2.bed", package="Motif2Site"))


# ChIP-seq background

Inputs <- c(system.file("extdata", "Input1.bed", package="Motif2Site"),
            system.file("extdata", "Input2.bed", package="Motif2Site"))


}
