% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_adonis_anosim.R
\name{mp_anosim}
\alias{mp_anosim}
\alias{mp_anosim,MPSE-method}
\alias{mp_anosim,MPSE}
\alias{mp_anosim,tbl_mpse-method}
\alias{mp_anosim,tbl_mpse}
\alias{mp_anosim,grouped_df_mpse-method}
\alias{mp_anosim,grouped_df_mpse}
\title{Analysis of Similarities (ANOSIM) with MPSE or tbl_mpse object}
\usage{
mp_anosim(
  .data,
  .abundance,
  .group,
  distmethod = "bray",
  action = "add",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_anosim}{MPSE}(
  .data,
  .abundance,
  .group,
  distmethod = "bray",
  action = "add",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_anosim}{tbl_mpse}(
  .data,
  .abundance,
  .group,
  distmethod = "bray",
  action = "add",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_anosim}{grouped_df_mpse}(
  .data,
  .abundance,
  .group,
  distmethod = "bray",
  action = "add",
  permutations = 999,
  seed = 123,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{.group}{The name of the column of the sample group information.}

\item{distmethod}{character the method to calculate pairwise distances,
default is 'bray'.}

\item{action}{character "add" joins the ANOSIM result to internal attribute of 
the object, "only" and "get" return 'anosim' object can be analyzed using the 
related vegan funtion.}

\item{permutations}{the number of permutations required, default is 999.}

\item{seed}{a random seed to make the ANOSIM analysis reproducible, default is 123.}

\item{...}{additional parameters see also 'anosim' of vegan.}
}
\value{
update object according action argument
}
\description{
Analysis of Similarities (ANOSIM) with MPSE or tbl_mpse object
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%<>\%
  mp_decostand(.abundance=Abundance)
# action = "get" will return a anosim object
mouse.time.mpse \%>\% 
  mp_anosim(.abundance=hellinger, .group=time, action="get")
# action = "only" will return a tbl_df that can be as the input of ggplot2.
library(ggplot2)
tbl <- mouse.time.mpse \%>\% 
       mp_anosim(.abundance=hellinger, 
                 .group=time,
                 permutations=999, # for more robust, set it to 9999
                 action="only")
tbl
tbl \%>\%
ggplot(aes(x=class, y=rank, fill=class)) + 
geom_boxplot(notch=TRUE, varwidth = TRUE)
}
\author{
Shuangbin Xu
}
