% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethylMix.R
\name{MethylMix_PlotModel}
\alias{MethylMix_PlotModel}
\title{The MethylMix_PlotModel function.}
\usage{
MethylMix_PlotModel(GeneName, MixtureModelResults, METcancer, GEcancer = NULL,
  METnormal = NULL)
}
\arguments{
\item{GeneName}{Name of the gene for which to create a MethylMix plot.}

\item{MixtureModelResults}{List returned by MethylMix function.}

\item{METcancer}{Matrix with the methylation data of cancer tissue with genes in rows and samples in columns.}

\item{GEcancer}{Gene expression data for cancer tissue with genes in rows and samples in columns (optional).}

\item{METnormal}{Matrix with the normal methylation data of the same genes as in METcancer (optional). Again genes in rows and samples in columns.}
}
\value{
a list with MethylMix plots, a histogram of the methylation data (MixtureModelPlot) and a scatterplot between DNA methylation and gene expression
(CorrelationPlot, is NULL if gene expression data is not provided). Both plots show the different mixture components identified.
}
\description{
Produces plots to represent MethylMix's output.
}
\examples{
# Load the three data sets needed for MethylMix
data(METcancer)
data(METnormal)
data(GEcancer)

# Run methylmix on a small set of example data
MethylMixResults <- MethylMix(METcancer, GEcancer, METnormal)

# Plot the most famous methylated gene for glioblastoma
MethylMix_PlotModel("MGMT", MethylMixResults, METcancer)

# Plot MGMT also with its normal methylation variation
MethylMix_PlotModel("MGMT", MethylMixResults, METcancer, METnormal = METnormal)

# Plot a MethylMix model for another gene
MethylMix_PlotModel("ZNF217", MethylMixResults, METcancer, METnormal = METnormal)

# Also plot the inverse correlation with gene expression (creates two separate plots)
MethylMix_PlotModel("MGMT", MethylMixResults, METcancer, GEcancer, METnormal)

# Plot all functional and differential genes
for (gene in MethylMixResults$MethylationDrivers) {
     MethylMix_PlotModel(gene, MethylMixResults, METcancer, METnormal = METnormal)
}

}
