% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_met_probes_info}
\alias{get_met_probes_info}
\title{Get HM450/EPIC manifest files from Sesame package}
\usage{
get_met_probes_info(genome = c("hg38", "hg19"), arrayType = c("450k", "EPIC"))
}
\arguments{
\item{genome}{Human genome of reference hg38 or hg19}

\item{arrayType}{"450k" or "EPIC" array}
}
\value{
A Granges with the DNAm array manifest
}
\description{
Returns a data frame with HM450/EPIC manifest information
files from Sesame package
}
\examples{
regions.names <- c("chr22:18267969-18268249","chr23:18267969-18268249")
regions.gr <- make_granges_from_names(regions.names)
make_names_from_granges(regions.gr)
}
