% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompAnnotationSource.R
\name{CompAnnotationSource}
\alias{CompAnnotationSource}
\alias{CompAnnotationSource-class}
\alias{matchSpectra,Spectra,CompAnnotationSource,Param-method}
\alias{show,CompAnnotationSource-method}
\alias{metadata,CompAnnotationSource-method}
\title{Compound Annotation Sources}
\usage{
\S4method{matchSpectra}{Spectra,CompAnnotationSource,Param}(query, target, param, ...)

\S4method{show}{CompAnnotationSource}(object)

\S4method{metadata}{CompAnnotationSource}(x, ...)
}
\arguments{
\item{query}{for \code{matchSpectra}: \link[Spectra:Spectra]{Spectra::Spectra} object with the query
spectra.}

\item{target}{for \code{matchSpectra}: object extending \link{CompAnnotationSource}
(such as \link{CompDbSource}) with the target (reference) spectra to compare
\code{query} against.}

\item{param}{for \code{matchSpectra}: parameter object (such as
\link{CompareSpectraParam}) defining the settings for the matching.}

\item{...}{additional parameters passed to \code{matchSpectra}.}

\item{object}{A \code{CompAnnotationSource} object.}

\item{x}{A \code{CompAnnotationSource} object.}
}
\description{
\code{CompAnnotationSource}s (i.e. classes extending the base virtual
\code{CompAnnotationSource} class) define and provide access to a (potentially
remote) compound annotation resource. This aims to simplify the integration
of external annotation resources by automating the actual connection
(or data resource download) process from the user. In addition, since the
reference resource is not directly exposed to the user it allows integration
of annotation resources that do not allow access to the full data.

Objects extending \code{CompAnnotationSource} available in this package are:
\itemize{
\item \code{\link[=CompDbSource]{CompDbSource()}}: annotation source referencing an annotation source in the
\verb{[CompoundDb::CompDb()]} format ( from the \code{CompoundDb} Bioconductor
package).
}

Classes extending \code{CompAnnotationSource} need to implement the \code{matchSpectra}
method with parameters \code{query}, \code{target} and \code{param} where \code{query} is
the \code{Spectra} object with the (experimental) query spectra, \code{target} the
object extending the \code{CompAnnotationSource} and \code{param} the parameter object
defining the similarity calculation (e.g. \code{\link[=CompareSpectraParam]{CompareSpectraParam()}}. The method
is expected to return a \link{MatchedSpectra} object.

\code{CompAnnotationSource} objects are not expected to contain any annotation
data. Access to the annotation data (in form of a \code{Spectra} object) is
suggested to be only established within the object's \code{matchSpectra} method.
This would also enable parallel processing of annotations as no e.g. database
connection would have to be shared across processes.
}
\section{Methods that need to be implemented}{


For an example implementation see \code{\link[=CompDbSource]{CompDbSource()}}.
\itemize{
\item \code{matchSpectra}: function to match experimental MS2 spectra against the
annotation source. See \code{\link[=matchSpectra]{matchSpectra()}} for parameters.
\item \code{metadata}: function to provide metadata on the annotation resource (host,
source, version etc).
\item \code{show} (optional): method to provide general information on the data
source.
}
}

\author{
Johannes Rainer, Nir Shachaf
}
