% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaHeatmap.R
\name{metaHeatmap}
\alias{metaHeatmap}
\title{Create a Heatmap for Comparing Multiple Samples}
\usage{
metaHeatmap(scorelist, samplenames, pvalcut = 0.05)
}
\arguments{
\item{scorelist}{list of outputs from pathwayAnalysis()}

\item{samplenames}{vector of samples names for axis labels}

\item{pvalcut}{numeric, the p val over which pathways will not be included}
}
\value{
metaHeatmap() returns a heatmap of significant dysregulated pathways

for each sample included
}
\description{
Create a Heatmap for Comparing Multiple Samples
}
\examples{
brca <- read.csv(system.file("extdata/BRCA_Scores.csv",
            package = "MetaPhOR"), header = TRUE, row.names = 1)

ovca <- read.csv(system.file("extdata/OVCA_Scores.csv",
            package = "MetaPhOR"), header = TRUE, row.names = 1)

prad <- read.csv(system.file("extdata/PRAD_Scores.csv",
            package = "MetaPhOR"), header = TRUE, row.names = 1)

all.scores <- list(brca, ovca, prad)
names <- c("BRCA", "OVCA", "PRAD")

metaHeatmap(scorelist = all.scores,
            samplenames = names,
            pvalcut = 0.05)
}
