% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighborVoting.R
\name{neighborVoting}
\alias{neighborVoting}
\title{Runs the neighbor voting algorithm.}
\usage{
neighborVoting(
  exp_labels,
  cell_labels,
  network,
  means = TRUE,
  node_degree_normalization = TRUE
)
}
\arguments{
\item{exp_labels}{A vector that indicates the dataset source of
each sample}

\item{cell_labels}{sample by cell type matrix that indicates the cell type
of each sample (0-absent; 1-present)}

\item{network}{sample by sample adjacency matrix, ranked and standardized
between 0-1}

\item{means}{default \code{TRUE}, determines output formatting}

\item{node_degree_normalization}{default \code{TRUE}, should predictions
be divided by node degree?}
}
\value{
If \code{means = TRUE} (default) a vector containing the mean of
AUROC values across cross-validation folds will be returned. If FALSE a list
is returned containing a cell type by dataset matrix of AUROC scores, for
each fold of cross-validation. Default is over-ridden when more than one cell
type is assessed.
}
\description{
The function performs cell type identity prediction based on 'guilt by
association' using cross validation. Performance is evaluated by calculating
the AUROC for each cell type.
}
\examples{
data("mn_data")
data("GOmouse")
library(SummarizedExperiment)
AUROC_scores = MetaNeighbor(dat = mn_data,
                            experiment_labels = as.numeric(factor(mn_data$study_id)),
                            celltype_labels = metadata(colData(mn_data))[["cell_labels"]],
                            genesets = GOmouse,
                            bplot = TRUE)
AUROC_scores
}
\seealso{
\code{\link{MetaNeighbor}}
}
