% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{aracne}
\alias{aracne}
\title{Create an adjacency matrix based on algorithm for the reconstruction
of accurate cellular networks}
\usage{
aracne(mi, eps = 0.05, ...)
}
\arguments{
\item{mi}{matrix, where columns are the samples and the rows are features
(metabolites), cell entries are mutual information values between the
features. As input, the mutual information (e.g. raw MI estimates) from the 
`knnmi.all` function of the `parmigene` package can be used.}

\item{eps}{numeric, used to remove the weakest edge of each triple of nodes}

\item{...}{not used here}
}
\value{
matrix, matrix with edges inferred from Reconstruction of accurate
cellular networks algorithm `aracne.a`
}
\description{
`aracne` infers an adjacency matrix using
the algorithm for the reconstruction of accurate cellular networks
using the `aracne.a` function from the
`parmigene` package. The function `aracne` will return the weighted
adjacency matrix of the inferred network after applying `aracne.a`.
}
\details{
For more details on the `aracne.a` function,
refer to `?parmigene::aracne.a`. `aracne.a` considers each triple of
edges independently and removes the weakest one if
\eqn{MI(i, j) < MI(j, k) - eps} and \eqn{MI(i, j) < MI(i, k) - eps}. See
Margolin et al. (2006) for further information.
}
\examples{
data("x_test", package = "MetNet")
x <- x_test[1:10, 3:ncol(x_test)]
x <- as.matrix(x)
x_z <- apply(x, 1, function(y) (y - mean(y)) / sd(y))
mi_x_z <- parmigene::knnmi.all(x_z)
aracne(mi_x_z, eps = 0.05)

}
\references{
Margolin et al. (2006): ARACNE : An algorithm for the reconstruction of
gene regulatory networks in a mammalian cellular context. BMC Bioinformatics,
S7, doi:
[10.1186/1471-2105-7-S1-S7](https://doi.org/10.1186/1471-2105-7-S1-S7)
}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
