% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingFunctions.R
\name{highlight}
\alias{highlight}
\title{Add links and highlight sectors}
\usage{
highlight(
  groupname,
  ind,
  linkDf,
  colour = NULL,
  transparency = 0.4,
  links = TRUE
)
}
\arguments{
\item{groupname}{\code{character} vector containing "group" and "name" to
display that is a unique identifier of the features, "group" and "name" have
to be separated by \code{"_"} where "group" is the first and "name" is the
last element}

\item{ind}{\code{numeric}, indices which will be highlighted}

\item{linkDf}{\code{data.frame}, in each row there is information about
features to be connected}

\item{colour}{\code{NULL} or \code{character}, \code{colour} defines the 
colours which are used for plotting, if `NULL` default colours are used}

\item{transparency}{\code{numeric}, defines the transparency of the colours}

\item{links}{\code{logical}, should links of unselected features be plotted}
}
\value{
The function will update an existing plot by highlighting a
specified sector and connected links.
}
\description{
A function to add links and highlight sectors to an initialised
and plotted \code{circlize} plot with one track.
}
\details{
Internal use for \code{shinyCircos} or outside of \code{shinyCircos} to 
reproduce the figure.
}
\examples{
data("spectra", package = "MetCirc")

## create similarity matrix
similarityMat <- Spectra::compareSpectra(sps_tissue[1:10],
    FUN = MsCoreUtils::ndotproduct, ppm = 20, m = 0.5, n = 2)
rownames(similarityMat) <- colnames(similarityMat) <- sps_tissue$name[1:10]

## order similarityMat according to retentionTime and update rownames
simM <- orderSimilarityMatrix(similarityMat, sps = sps_tissue[1:10],
    type = "retentionTime")

## create link matrix
linkDf <- createLinkDf(similarityMatrix = simM, sps = sps_tissue,
    condition = c("SPL", "LIM", "ANT", "STY"), lower = 0.01, upper = 1)

## cut link matrix (here: only display links between groups)
linkDf_cut <- cutLinkDf(linkDf, type = "inter")

## set circlize parameters
circos.clear()
circos.par(gap.degree = 0, cell.padding = c(0.0, 0, 0.0, 0),
    track.margin = c(0.0, 0))
groupname <- c(as.character(linkDf_cut[, "spectrum1"]),
    as.character(linkDf_cut[, "spectrum2"]))
groupname <- unique(groupname)

## here: set indSelected arbitrarily
indSelected <- c(2,3)

## actual plotting
plotCircos(groupname, linkDf_cut, initialize = TRUE,
    featureNames = TRUE, cexFeatureNames = 0.2, groupSector = TRUE,
    groupName = FALSE, links = FALSE, highlight = TRUE)

## highlight
highlight(groupname = groupname, ind = indSelected, linkDf = linkDf_cut,
    colour = NULL, transparency = 0.4, links = TRUE)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
