% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSegment.R
\name{readSegment}
\alias{readSegment}
\title{readSegment}
\usage{
readSegment(
  segFile,
  gisticAmpGenesFile = NULL,
  gisticDelGenesFile = NULL,
  gisticAllLesionsFile = NULL,
  gistic.qval = 0.25,
  min.seg.size = 500,
  txdb = NULL,
  min.overlap.len = 50,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{segFile}{The segment file.}

\item{gisticAmpGenesFile}{Amplification Genes file generated by GISTIC. Default NULL.}

\item{gisticDelGenesFile}{Deletion Genes file generated by GISTIC. Default NULL.}

\item{gisticAllLesionsFile}{Information of all lesions generated by GISTIC. Default NULL.}

\item{gistic.qval}{The threshold of gistic Q value. Default 0.25.}

\item{min.seg.size}{The smallest size of segments. Default 500.}

\item{txdb}{A TxDb object. i.e., TxDb.Hsapiens.UCSC.hg19.knownGene. Default NULL.}

\item{min.overlap.len}{The minimum insertion size of segment and gene. Default 50.}

\item{verbose}{Whether to display details in the console. Default TRUE.}

\item{...}{... Other options passed to \code{\link{cna2gene}}.}
}
\value{
a list of segmentation data frame
}
\description{
readSegment
}
\examples{
segFile <- system.file("extdata", "CRC_HZ.seg.txt", package = "MesKit")
gisticAmpGenesFile <- system.file("extdata", "COREAD_amp_genes.conf_99.txt", package = "MesKit")
gisticDelGenesFile <- system.file("extdata", "COREAD_del_genes.conf_99.txt", package = "MesKit")
gisticAllLesionsFile <- system.file("extdata", "COREAD_all_lesions.conf_99.txt", package = "MesKit")
seg <- readSegment(segFile = segFile,
                   gisticAmpGenesFile = gisticAmpGenesFile,
                   gisticDelGenesFile = gisticDelGenesFile,
                   gisticAllLesionsFile = gisticAllLesionsFile)

}
