% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCNA.R
\name{plotCNA}
\alias{plotCNA}
\title{plotCNA}
\usage{
plotCNA(
  seg,
  patient.id = NULL,
  sampleOrder = NULL,
  chrSilent = NULL,
  refBuild = "hg19",
  sample.text.size = 11,
  chrom.text.size = 3,
  legend.text.size = 9,
  legend.title.size = 11,
  annot.text.size = 3,
  sample.bar.height = 0.5,
  chrom.bar.height = 0.5,
  showRownames = TRUE,
  removeEmptyChr = TRUE,
  showCytoband = FALSE,
  showGene = FALSE,
  use.tumorSampleLabel = FALSE
)
}
\arguments{
\item{seg}{Object generated by \code{\link{readSegment}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{sampleOrder}{A named list which contains the sample order used in plotting the final profile. Default NULL.}

\item{chrSilent}{Chromosomes excluded in the analysis. e.g, 1, 2, 3. Default NULL.}

\item{refBuild}{Human reference genome versions of hg18, hg19 or hg38 by UCSC. Default "hg19".}

\item{sample.text.size}{Fontsize of sample name. Default 11.}

\item{chrom.text.size}{Fontsize of chromosome text. Default 3.}

\item{legend.text.size}{Fontsize of legend text. Default 9.}

\item{legend.title.size}{Fontsize of legend title. Default 11.}

\item{annot.text.size}{Fontsize of cytoband or gene symbols. Default 3.}

\item{sample.bar.height}{Bar height of each sample. Default 0.5.}

\item{chrom.bar.height}{Bar height of each chromosome. Default 0.5.}

\item{showRownames}{Logical (Default: TRUE). Show sample names of rows.}

\item{removeEmptyChr}{Remove empty chromosomes that do not exist in all samples. Default TRUE.}

\item{showCytoband}{Logical (Default: FALSE). Show cytobands on the plot. Only when the seg object is created with GISTIC results, this parameter can be TRUE.}

\item{showGene}{Logical (Default: FALSE). Show gene symbols on the plot. Only when the seg object is created with txdb, this parameter can be TRUE.}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). Rename the 'Tumor_Sample_Barcode' with 'Tumor_Sample_Label'.}
}
\value{
a heatmap plot of CNA profile
}
\description{
plotCNA
}
\examples{
segFile <- system.file("extdata", "CRC_HZ.seg.txt", package = "MesKit")
seg <- readSegment(segFile = segFile)
plotCNA(seg)

## showCytoband
gisticAmpGenesFile <- system.file("extdata", "COREAD_amp_genes.conf_99.txt", package = "MesKit")
gisticDelGenesFile <- system.file("extdata", "COREAD_del_genes.conf_99.txt", package = "MesKit")
gisticAllLesionsFile <- system.file("extdata", "COREAD_all_lesions.conf_99.txt", package = "MesKit")
seg <- readSegment(segFile = segFile,
                   gisticAmpGenesFile = gisticAmpGenesFile,
                    gisticDelGenesFile = gisticDelGenesFile,
                   gisticAllLesionsFile = gisticAllLesionsFile)
plotCNA(seg, showCytoband = TRUE)


}
