% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitSignatures.R
\name{fitSignatures}
\alias{fitSignatures}
\title{fitSignatures}
\usage{
fitSignatures(
  tri_matrix = NULL,
  patient.id = NULL,
  signaturesRef = "cosmic_v2",
  associated = NULL,
  min.mut.count = 15,
  signature.cutoff = 0.1
)
}
\arguments{
\item{tri_matrix}{A matrix or a list of matrix generated by \code{\link{triMatrix}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included}

\item{signaturesRef}{Signature reference,Users can upload their own reference. 
Default "cosmic_v2". Option: "exome_cosmic_v3","nature2013".}

\item{associated}{Associated Vector of associated signatures. 
If given, will narrow the signatures reference to only the ones listed. Default NULL.}

\item{min.mut.count}{The threshold for the variants in a branch. Default 15.}

\item{signature.cutoff}{Discard any signature relative contributions with a weight less than this amount. Default 0.1.}
}
\value{
A list of data frames, each one contains treeMSOutput, 
containing information about each set/branch's mutational signature.
}
\description{
Find nonnegative linear combination of mutation signatures to reconstruct matrix and 
calculate cosine similarity based on somatic SNVs.
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")

## Load a reference genome.
library(BSgenome.Hsapiens.UCSC.hg19)

phyloTree <- getPhyloTree(maf, patient.id = 'V402')
tri_matrix <- triMatrix(phyloTree)
fitSignatures(tri_matrix)
}
