% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifyMut.R
\name{classifyMut}
\alias{classifyMut}
\title{classifyMut}
\usage{
classifyMut(maf, patient.id = NULL, class = "SP", classByTumor = FALSE, ...)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.
Classify SSNVs/Indels into Shared/P-shared/Private, Clonal/Subclonl
or Shared-Clonal/P-shared-Clonal/Private-Clonal/Shared-Subclonal/P-shared-SubClonal/Private-SubClonal}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included}

\item{class}{The class which would be represented. Default: "SP" (Shared pattern: Public/Shared/Private),
other options: "CS" (Clonal status: Clonal/Subclonl) and "SPCS".}

\item{classByTumor}{Logical (Default: FALSE). Classify mutations based on "Tumor_ID".}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
A data.frame with classification of mutations for each patient
}
\description{
classifyMut
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
classifyMut(maf, class = "SP")
}
