% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_dimensionreduction.R
\name{explVar}
\alias{explVar}
\title{Retrieve the explained variance for each principal component (PCA) or
axis (PCoA)}
\usage{
explVar(d, type = c("PCA", "PCoA"))
}
\arguments{
\item{d}{\code{prcomp} or \code{list} from \code{cmdscale}}

\item{type}{\code{character}, one of \code{"PCA"} or \code{"PCoA"}}
}
\value{
\code{numeric} vector with the proportion of explained variance 
for each PC or Axis
}
\description{
The function \code{explVar} calculates the proportion of explained variance 
for each principal component (PC, \code{type = "PCA"}) and axis 
(\code{type = "PCoA"}).
}
\details{
\code{explVar} uses the function \code{prcomp} from the \code{stats} package 
to retrieve the explained standard deviation per PC 
(\code{type = "PCA"}) and the function \code{cmdscale} from the \code{stats} 
package to retrieve the explained variation based on eigenvalues per 
Axis (\code{type = "PCoA"}).
}
\examples{
x <- matrix(seq_len(100), nrow = 10, ncol = 10, 
    dimnames = list(seq_len(10), paste("sample", seq_len(10))))
set.seed(1)
x <- x + rnorm(100)

## run for PCA
pca <- dimensionReduction(x = x, 
    params = list(center = TRUE, scale = TRUE), type = "PCA")[[2]]
explVar(d = pca, type = "PCA")

## run for PCoA
pcoa <- dimensionReduction(x = x, 
    params = list(method = "euclidean"), type = "PCoA")[[2]]
explVar(d = pcoa, type = "PCoA")

}
\author{
Thomas Naake
}
